﻿#nullable enable
namespace Hims.Api.Models.Account
{
    using System.Collections.Generic;
    using Shared.Library.Enums;

    /// <summary>
    /// The verify OTP request.
    /// </summary>
    public class VerifyOTPRequest
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the account types.
        /// </summary>
        public IEnumerable<AccountType> AccountTypes { get; set; } = new List<AccountType>();

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public DeviceType DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the device key.
        /// </summary>
        public string? DeviceToken { get; set; }

        /// <summary>
        /// Gets or sets the device ID.
        /// </summary>
        public string? DeviceId { get; set; }
    }
}